using DG.Tweening;
using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.SceneManagement;

public class FadeScene : Fade
{
    [SerializeField] CanvasGroup StartcanvasGroup;
    
    public override void Start()
    {
        base.Start();
        if (StartcanvasGroup != null) StartcanvasGroup.DOFade(0, FadeDuration);
    }
    public override void MakeThing(string sceneName)
    {
        StartCoroutine(LoadScene(sceneName));
    }
    IEnumerator LoadScene(string sceneName)
    {
        if (!string.IsNullOrEmpty(sceneName))
        {
            AsyncOperation asyncOperation = SceneManager.LoadSceneAsync(sceneName);
            while (!asyncOperation.isDone)
            {
                yield return null;

            }
        }
    }
    public void ReloadScene()
    {
        SceneManager.LoadScene(SceneManager.GetActiveScene().buildIndex);
    }
    public void SetLevel(int level)
    {
        PlayerPrefs.SetInt("Level", level);

    }
    private void OnDestroy()
    {
        DOTween.Kill(StartcanvasGroup);
    }
}
